'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Public Sub Kilometer_umwandeln()

    Dim km_Text_bereinigt As String
    Dim Komma, Vorzeichen As Boolean
    Dim i, NachkommaStellen As Long
    
    T_Km = Trim(T_Km)
    
    'wenn Km leer gelassen wurde:
    If (IsNull(T_Km)) Or (Len(T_Km) = 0) Then
        km_WertNeu = 0
    Else
        'ansonsten Versuch, Format automatisch zu wandeln
        '(bei Fehler, automatische Abarbeitung der eigenen Funktion)
        On Error GoTo ERR_Kilometer_umwandeln
        km_WertNeu = CDbl(T_Km)
        'Runden auf erwnschte Nachkommastellen
        Select Case km_DezimalAnzahl
            Case 0
                km_WertNeu = CDbl(Format(km_WertNeu, "#0"))
            Case 1
                km_WertNeu = CDbl(Format(km_WertNeu, "0.0"))
            Case 2
                km_WertNeu = CDbl(Format(km_WertNeu, "0.00"))
        End Select
    End If
    
    
Exit_Kilometer_umwandeln:
    
    Exit Sub
    
    
ERR_Kilometer_umwandeln:
    'Wenn die automatische Formatumwandlung fehl schlgt, dann
    'greift die eigene Funktion:
    
    'Textdarstellung der km von unzulssigen Zeichen bereinigen
    'und Dezimalzeichen in vorgegebenen Wert umwandeln
    '...Text dabei von links beginnend durchforsten
    Komma = False
    Vorzeichen = False
    NachkommaStellen = 0
    km_Text_bereinigt = ""
    For i = 1 To Len(T_Km)
        Select Case Mid(T_Km, i, 1)
            Case "-"                            'Minuszeichen?
                If i = 1 Then                   'Minuszeichen nur an 1. Stelle erlaubt
                    km_Text_bereinigt = "-"
                    Vorzeichen = True
                End If
            Case km_DezimalTrenner              'Dezimaltrennzeichen?
                If (Komma = False) Then         'nur beachten, falls noch kein Dez.trennzeichen
                    If (Vorzeichen = False) Then
                        If (Len(km_Text_bereinigt) >= 1) Then
                            'wenn kein "-" vorhanden, dann muss wenigstens eine Ziffer vor dem Trennzeichen sein
                            km_Text_bereinigt = km_Text_bereinigt & km_DezimalTrenner
                            Komma = True
                        End If
                    Else
                        If (Len(km_Text_bereinigt) >= 2) Then
                            'wenn "-" vorhanden, mssen mind. 2 Zeichen im bereinigten Text sein ("-0...")
                            km_Text_bereinigt = km_Text_bereinigt & km_DezimalTrenner
                            Komma = True
                        End If
                    End If
                End If
            Case "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                If (Komma = False) Then
                    km_Text_bereinigt = km_Text_bereinigt & Mid(T_Km, i, 1)
                Else
                    If NachkommaStellen <= km_DezimalAnzahl Then
                        km_Text_bereinigt = km_Text_bereinigt & Mid(T_Km, i, 1)
                        NachkommaStellen = NachkommaStellen + 1
                    End If
                End If
        End Select
        If NachkommaStellen > km_DezimalAnzahl Then Exit For
    Next i
    
    'Umwandlung des bereinigten Textes in einen Zahlenwert
    km_WertNeu = CDbl(km_Text_bereinigt)
    
    If NachkommaStellen > km_DezimalAnzahl Then
        'Runden auf erwnschte Nachkommastellen
        Select Case km_DezimalAnzahl
            Case 0
                km_WertNeu = CDbl(Format(km_WertNeu, "#0"))
            Case 1
                km_WertNeu = CDbl(Format(km_WertNeu, "0.0"))
            Case 2
                km_WertNeu = CDbl(Format(km_WertNeu, "0.00"))
        End Select
    End If
    
    Resume Exit_Kilometer_umwandeln
    
End Sub

Public Sub Kontakt_verarbeiten()
        
        
'TEST-Meldungen bei Outlook-97 (int.V. 8.02)
'MsgBox (meinTermin.Attachments(1).DisplayName)      '=> ("Outlook-Nachrichtenanlage") "Silke Mller"
'MsgBox (meinTermin.Attachments(1).Type)             '=> 6 (OLE);  5 (Embedded)!!!  <<<==== Kontakte als 1.Anlage(!) dem Termin anhngen
'MsgBox (meinTermin.Attachments(1).Subject)         'Error
'MsgBox (meinTermin.Attachments(1).Source)          'Error
'MsgBox (meinTermin.Attachments(1).Position)         '=> 1  (1. Anlage)



    'alt: FilterKontakt = "[Kunden_ID] = '" & meinKontakt.EntryID & "'"
    FilterKontakt = "[Kunden_ID] = '" & KontaktID & "'"
    rstKontakte.FindFirst FilterKontakt
    If rstKontakte.NoMatch Then
        'Kontakt neu: anlegen ------------------------------------
        On Error GoTo ErrorKontaktAnlegenFehler
        rstKontakte.AddNew
        rstKontakte!Kunden_ID = meinKontakt.EntryID
        rstKontakte!Name1 = " "
        rstKontakte!Name2 = " "
        rstKontakte!Name3 = " "
        If Not IsNull(meinKontakt.CompanyName) Then _
            If Len(meinKontakt.CompanyName) > 0 Then rstKontakte!Name1 = Left(meinKontakt.CompanyName, 100)
        If Not IsNull(meinKontakt.LastName) Then _
            If Len(meinKontakt.LastName) > 0 Then rstKontakte!Name2 = Left(meinKontakt.LastName, 100)
        If Not IsNull(meinKontakt.FirstName) Then _
            If Len(meinKontakt.FirstName) > 0 Then rstKontakte!Name2 = Left((meinKontakt.FirstName & " " & rstKontakte!Name2), 100)
        If Not IsNull(meinKontakt.Title) Then _
            If Len(meinKontakt.Title) > 0 Then rstKontakte!Name2 = Left((meinKontakt.Title & " " & rstKontakte!Name2), 100)
        If Not IsNull(meinKontakt.Suffix) Then _
            If Len(meinKontakt.Suffix) > 0 Then rstKontakte!Name2 = Left((meinKontakt.Suffix & " " & rstKontakte!Name2), 100)
        'wenn Name1 leer, dann Name2 nach Name1 verschieben
        If (Len(Trim(rstKontakte!Name1)) = 0) And (Len(Trim(rstKontakte!Name2)) > 0) Then
            rstKontakte!Name1 = rstKontakte!Name2
            rstKontakte!Name2 = " "
        End If
        If Not IsNull(meinKontakt.BusinessAddressStreet) Then _
            If Len(meinKontakt.BusinessAddressStreet) > 0 Then rstKontakte!Strasse = Left(meinKontakt.BusinessAddressStreet, 100)
        If Not IsNull(meinKontakt.BusinessAddressPostalCode) Then _
            If Len(meinKontakt.BusinessAddressPostalCode) > 0 Then rstKontakte!PLZ = Left(meinKontakt.BusinessAddressPostalCode, 10)
        If Not IsNull(meinKontakt.BusinessAddressCity) Then _
            If Len(meinKontakt.BusinessAddressCity) > 0 Then rstKontakte!Ort = Left(meinKontakt.BusinessAddressCity, 100)
        If Not IsNull(meinKontakt.BusinessAddressCountry) Then _
            If Len(meinKontakt.BusinessAddressCountry) > 0 Then rstKontakte!Land = Left(meinKontakt.BusinessAddressCountry, 100)
        If rstKontakte!Land = "Deutschland" Then rstKontakte!Land = " "
        rstKontakte!Telefon1 = " "
        rstKontakte!Telefon2 = " "
        rstKontakte!Fax = " "
        'meinKontakt.Email1Address = " "         ' ???
        'meinKontakt.WebPage = " "               ' ??? meinKontakt.
        'meinKontakt.Gebuehr_indiv = False       ' ???
        rstKontakte!UpdateDatum = UpdateDatum
        rstKontakte.Update
        'Nach einer Aktualisierung, den Datensatz wieder zum Aktuellen machen
        rstKontakte.FindFirst FilterKontakt
    Else
        'nur aktualisieren, wenn ungleich Dummy-Kontakt
        If KontaktDummy_notwendig = False Then
            'Kontakt bereits vorhanden: Aktualisierung prfen ---------
            'nur aktualisieren, wenn heute noch nicht erfolgt ---------
            If rstKontakte!UpdateDatum <> UpdateDatum Then
                On Error GoTo ErrorKontaktUpdateFehler
                rstKontakte.Edit
                rstKontakte!Name1 = " "
                rstKontakte!Name2 = " "
                'rstKontakte!Name3 = " "            'nicht automatisch, da evtl. per Hand gendert
                If Not IsNull(meinKontakt.CompanyName) Then _
                    If Len(meinKontakt.CompanyName) > 0 Then rstKontakte!Name1 = Left(meinKontakt.CompanyName, 100)
                If Not IsNull(meinKontakt.LastName) Then _
                    If Len(meinKontakt.LastName) > 0 Then rstKontakte!Name2 = Left(meinKontakt.LastName, 100)
                If Not IsNull(meinKontakt.FirstName) Then _
                    If Len(meinKontakt.FirstName) > 0 Then rstKontakte!Name2 = Left((meinKontakt.FirstName & " " & rstKontakte!Name2), 100)
                If Not IsNull(meinKontakt.Title) Then _
                    If Len(meinKontakt.Title) > 0 Then rstKontakte!Name2 = Left((meinKontakt.Title & " " & rstKontakte!Name2), 100)
                If Not IsNull(meinKontakt.Suffix) Then _
                    If Len(meinKontakt.Suffix) > 0 Then rstKontakte!Name2 = Left((meinKontakt.Suffix & " " & rstKontakte!Name2), 100)
                'wenn Name1 leer, dann Name2 nach Name1 verschieben
                If (Len(Trim(rstKontakte!Name1)) = 0) And (Len(Trim(rstKontakte!Name2)) > 0) Then
                    rstKontakte!Name1 = rstKontakte!Name2
                    rstKontakte!Name2 = " "
                End If
                If Not IsNull(meinKontakt.BusinessAddressStreet) Then _
                    If Len(meinKontakt.BusinessAddressStreet) > 0 Then rstKontakte!Strasse = Left(meinKontakt.BusinessAddressStreet, 100)
                If Not IsNull(meinKontakt.BusinessAddressPostalCode) Then _
                    If Len(meinKontakt.BusinessAddressPostalCode) > 0 Then rstKontakte!PLZ = Left(meinKontakt.BusinessAddressPostalCode, 10)
                If Not IsNull(meinKontakt.BusinessAddressCity) Then _
                    If Len(meinKontakt.BusinessAddressCity) > 0 Then rstKontakte!Ort = Left(meinKontakt.BusinessAddressCity, 100)
                If Not IsNull(meinKontakt.BusinessAddressCountry) Then _
                    If Len(meinKontakt.BusinessAddressCountry) > 0 Then rstKontakte!Land = Left(meinKontakt.BusinessAddressCountry, 100)
                If rstKontakte!Land = "Deutschland" Then rstKontakte!Land = " "
                'rstKontakte!Telefon1 = " "         'nicht automatisch, da evtl. per Hand gendert
                'rstKontakte!Telefon2 = " "         'nicht automatisch, da evtl. per Hand gendert
                'rstKontakte!Fax = " "              'nicht automatisch, da evtl. per Hand gendert
                'meinKontakt.Email1Address = " "    'nicht automatisch, da evtl. per Hand gendert  ' ???
                'meinKontakt.WebPage = " "          'nicht automatisch, da evtl. per Hand gendert  ' ??? meinKontakt.
                'meinKontakt.Gebuehr_indiv = False  'nicht automatisch, da evtl. per Hand gendert  ' ???
                rstKontakte!UpdateDatum = UpdateDatum
                rstKontakte.Update
                'Nach einer Aktualisierung, den Datensatz wieder zum Aktuellen machen
                rstKontakte.FindFirst FilterKontakt
            End If          'Kontaktupdate <> Updatedatum
        End If              '<> Dummy-Kontakt
    End If                  'Kontaktanzahl = 0
  
    Exit Sub
    
    
ErrorKontaktAnlegenFehler:
    FehlerCode = "ErrorKontaktAnlegenFehler"
    FehlerNummer = err.Number
    Exit Sub
    
ErrorKontaktUpdateFehler:
    FehlerCode = "ErrorKontaktUpdateFehler"
    FehlerNummer = err.Number
    Exit Sub
    
End Sub

Public Sub Termin_verarbeiten()
    
    Dim FilterTerminZwischen As String
    Dim FilterKategorie As String
    
    Dim idx As Integer                  'Zhler fr CoOrdner-Array-Durchlauf
    Dim KontaktOrdner As Object         'Outlook.Folder
    Dim AufAnlagenPruefen As Boolean    'falls bei LINK-Prfung kein Treffer
    
    
    'Variablendefinition *mit* Verweis auf Outlook-Bibliothek
    '   Dim myKontaktLinks As Links
    '   Dim myKontaktLink As Link
    '   Dim myKontaktLinkItem As ContactItem
    'Variablendefinition OHNE Verweis auf Outlook-Bibliothek
    Dim myKontaktLinks As Object
    Dim myKontaktLink As Object
    Dim myKontaktLinkItem As Object


    KontaktDummy_notwendig = False
    
    
    ' (1.) ERSTE Prfung auf Kontakt-LINKS am Termin
    '           wenn ohne Erfolg, dann
    ' (2.) ZWEITE Prfung auf Kontakt-ANLAGEN am Termin
    On Error GoTo TerminAttachmentsPruefen      'wenn die Prfung auf .Links fehlschlgt
    Set myKontaktLinks = Nothing                '1. erst leeren
    Set myKontaktLinks = meinTermin.Links       '2. dann Versuch, zu fllen
    If myKontaktLinks Is Nothing Then GoTo TerminAttachmentsPruefen
    
    On Error GoTo 0                'vorerst
    AufAnlagenPruefen = False
    
    If myKontaktLinks.Count > 0 Then
        If myKontaktLinks.Item(1).Type = 40 Then            '40 = olContact = ContactItem
            'Kontakteintrag aus dem Link *extrahieren*
            Set myKontaktLink = myKontaktLinks.Item(1)
            'Set myKontaktLinkItem = myKontaktLink.Item     'erst weiter unten
        Else
            'Verknpfung nicht vom Typ ContaktItem
            If TerminOhneKontakt_verarbeiten = "F" Then
                'wenn fehlender Kontakt = "F"ehler bedeutet
                FehlerCode = "ErrorKontaktverknuepfungFehlt"        'nicht GANZ korrekt...
                Exit Sub
            Else
                KontaktDummy_notwendig = True
                TerminOhneKontakt_Zaehler = TerminOhneKontakt_Zaehler + 1
            End If
        End If
    Else
        'NEU: Auf ANLAGEN prfen
        AufAnlagenPruefen = True
'''''        'Keine Kontaktverknpfung!
'''''        If TerminOhneKontakt_verarbeiten = "F" Then
'''''            'wenn fehlender Kontakt = "F"ehler bedeutet
'''''            FehlerCode = "ErrorKontaktverknuepfungFehlt"
'''''            Exit Sub
'''''        Else
'''''            KontaktDummy_notwendig = True
'''''            TerminOhneKontakt_Zaehler = TerminOhneKontakt_Zaehler + 1
'''''        End If
    End If
    
    If AufAnlagenPruefen = True Then GoTo TerminAttachmentsPruefen
    
    
    'interne lfd. Nr. des Kunden ermitteln
    
    If KontaktDummy_notwendig = False Then
        On Error GoTo ErrorKontaktNichtGefunden
        Set meinKontakt = myKontaktLink.Item
    End If
    
    GoTo TerminAttachmentsPruefenUeberspringen
    
    
TerminAttachmentsPruefen:
    '1. Brauchbare Anlage ermitteln:
    'ACHTUNG bei Anlagen: als "Attachmets" oder "Links" (Richtig ist Attachment, wegen des bergebenen Namens)
    T_Kontakt = ""
    If meinTermin.Attachments.Count > 0 Then
        T_Kontakt = meinTermin.Attachments.Item(1).DisplayName
    End If
    If T_Kontakt = "" Then
        'Keine Kontaktverknpfung!
        If TerminOhneKontakt_verarbeiten = "F" Then
            'wenn fehlender Kontakt = "F"ehler bedeutet
            FehlerCode = "ErrorKontaktverknuepfungFehlt"
            Exit Sub
        Else
            KontaktDummy_notwendig = True
            TerminOhneKontakt_Zaehler = TerminOhneKontakt_Zaehler + 1
        End If
    End If
    
    '2. Wenn brauchbare Anlage gefunden, dann Kontakt ermitteln:
    Set meinKontakt = Nothing
    If KontaktDummy_notwendig = False Then
        'vorausgesetzt CoIndex ist grer -1 (d.h.: mindestens 1 KontaktOrdner in Outlook vorhanden)
        'T_Kontakt = "[FullName]=""" & T_Kontakt & """ or [FileAs]=""" & T_Kontakt & """"
        For idx = 0 To CoIndex
            Set KontaktOrdner = meinNamespace.GetFolderFromID(CoOrdner(idx), CoContainer(idx))
            
            On Error GoTo NaechsterKontaktOrdner
            Set meinKontakt = KontaktOrdner.Items.Item(T_Kontakt)
            Exit For    'wird nur erreicht, wenn Kontakt gefunden wurde
            
NaechsterKontaktOrdner:
            Resume ZumNaechstenKontaktOrdner
            'ohne weitere Fehlerbehandlung...
ZumNaechstenKontaktOrdner:
            'und weiter gehts...
        Next idx
    End If
    'wenn in allen Kontakt-Odnern kein passender Kontakt gefunden wurde
    If meinKontakt Is Nothing Then
        If TerminOhneKontakt_verarbeiten = "F" Then
            'wenn fehlender Kontakt = "F"ehler bedeutet
            FehlerCode = "ErrorKontaktverknuepfungFehlt"
            Exit Sub
        Else
            KontaktDummy_notwendig = True
            TerminOhneKontakt_Zaehler = TerminOhneKontakt_Zaehler + 1
        End If
    End If
    
    
TerminAttachmentsPruefenUeberspringen:
    
    On Error GoTo ErrorTerminUpdateFehler

    '===== Termin verarbeiten Beginn =====
    
    'Gundstzliche Vorgehensweise zur Terminsuche (Kriterien):
    '   1) mit START, TERMIN_ID, KONTAKT_ID
    '   ...wenn nicht gefunden, dann...
    '   2) nur mit START, TERMIN_ID
    
    FilterTerminZwischen = ""
    'weil Datenbankabfragen mit kombinierten Datum-Zeit-Feldern difiziel sind,
    'wird der Starttermin zerlegt in der Datenbank gespeichert
    FilterTerminZwischen = "[S_Jahr] = " & Year(T_Start) & _
        " AND [S_Monat] = " & Month(T_Start) & _
        " AND [S_Tag] = " & Day(T_Start) & _
        " AND [S_Stunde] = " & Hour(T_Start) & _
        " AND [S_Minute] = " & Minute(T_Start) & _
        " AND [Termin_ID] = """ & T_ID & """"
    
    FilterTermin = FilterTerminZwischen
    
    If KontaktDummy_notwendig = True Then
        KontaktID = KontaktDummy
    Else
        KontaktID = meinKontakt.EntryID
    End If
    
    'Ermittlung der lfd_Nr fr den Kontakt, sofern er bereits vorhanden ist
    FilterKontakt = "[Kunden_ID] = '" & KontaktID & "'"
    rstKontakte.FindFirst FilterKontakt
    If rstKontakte.NoMatch Then
        'wenn noch kein Kontakt vorhanden ist, kann die Suche nach dem Termin sofort erfolgen,
        'ohne Kontakt
        rstTermine.FindFirst FilterTermin
    Else
        'wenn ein Kontakt vorhanden ist, wird dierer zunchst in die Suche einbezogen
        FilterTermin = FilterTerminZwischen & " AND [lfd_Nr_Kunde] = " & rstKontakte!lfd_Nr
        rstTermine.FindFirst FilterTermin
        If rstTermine.NoMatch Then
            'wenn kein Termin gefunden, wird nochmal ohne Kontakt gesucht,
            'falls der Kontakteintrag zu einem Termin gendert wurde,
            'aber der Termin bereits in der Datenbank ist (mit dem alten Kontakteintrag)
            FilterTermin = FilterTerminZwischen
            rstTermine.FindFirst FilterTermin
        End If
    End If
    
    
    
    If rstTermine.NoMatch Then

        'Termin neu anlegen
        
'>>>>>>>>
        'Privattermine nur anlegen, wenn die bernahme/Berechnung erwnscht ist
        If (T_Privat = True) And (Privat_verarbeiten = False) Then
            '...nichts tun... (Privattermin, der nicht bernommen werden soll)
        Else
            'zuerst Kategorie auflsen und evtl. anlegen,
            'fr Outlook bis 2003 und fr Termin-Kategorien, die nicht in der
            'Kategorie-Liste von Outlook standen (sondern nur im Termin)
            FilterKategorie = "SELECT * FROM Kategorien WHERE [Name1]='" & T_Kategorie & "'"
            Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
            If (rstKategorien.RecordCount = 0) Then
                'Kategorie nur anlegen, wenn keine Strenge Prfung auf Kategorievorgabeliste
                'oder sowieso alle Kategorien angelegt werden sollen
                If (KatStrengePruefung = False) Or (KatUebernahmeArt = 0) Then
                    rstKategorien.AddNew
                    rstKategorien!Kategorie_ID = "X"        'darf nicht leer sein, wegen Abfrage fr Listfeld
                    rstKategorien!Name1 = T_Kategorie
                    rstKategorien!FarbNr = "9999"           ' sh. Update-Routine !!!
                    rstKategorien!Rot = 255                 ' -"- (wei)
                    rstKategorien!Gruen = 255               ' -"-
                    rstKategorien!Blau = 255                ' -"-
                    rstKategorien!Preis_indiv = False
                    rstKategorien!MwSt_indiv = False
                    rstKategorien!MwSteuer = 0
                    rstKategorien.Update
                Else
                    'bei Strenger Kategorievorgabe die beim Termin gefundene und nicht in der
                    'Vorgabeliste enthaltene Kategorie durch "(ohne Kategorie)" ersetzen!
                    T_Kategorie = "(ohne Kategorie)"
                End If
            End If
            rstKategorien.Close
            
            
            
            
            rstTermine.AddNew
            
            Kontakt_verarbeiten
            If FehlerCode <> "" Then Exit Sub
            
            'interne lfd. Nr. des Kunden in den neuen Termineintrag bernehmen
            rstTermine!lfd_Nr_Kunde = rstKontakte!lfd_Nr
        
            'restliche Terminfelder bernehmen
            rstTermine!Termin_ID = T_ID
            rstTermine!Start = T_Start
            rstTermine!Ende = T_Ende
            rstTermine!Dauer = T_Dauer
            rstTermine!geloescht = False
            rstTermine!Betreff = T_Betreff
            
            FilterKategorie = "SELECT * FROM Kategorien WHERE [Name1]='" & T_Kategorie & "'"
            Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
            rstKategorien.MoveFirst
                rstTermine!lfd_Nr_Kategorie = rstKategorien!lfd_Nr
            rstKategorien.Close
            
            rstTermine!Privat = T_Privat
            If km_Erfassung = True Then
                Kilometer_umwandeln
                rstTermine!km_Anzahl = km_WertNeu
            Else
                rstTermine!km_Anzahl = 0
            End If
            rstTermine!berechnet = False
            rstTermine!geaendert_seit_Re = False
            rstTermine!Su_Re_Netto = 0
            rstTermine!Su_Kalkulation = 0
            'rstTermine!Re_Datum
            rstTermine!Re_Nr = " "                  'oder anderen Platzhalter?
            rstTermine!ohne_Adresse = False
            rstTermine!Update = False
            rstTermine!UpdateDatum = UpdateDatum
            'weil Datenbankabfragen mit kombinierten Datum-Zeit-Feldern difiziel sind,
            'wird der Starttermin zerlegt in der Datenbank gespeichert
            rstTermine!S_Jahr = Year(T_Start)
            rstTermine!S_Monat = Month(T_Start)
            rstTermine!S_Tag = Day(T_Start)
            rstTermine!S_Stunde = Hour(T_Start)
            rstTermine!S_Minute = Minute(T_Start)
            rstTermine!E_Jahr = Year(T_Ende)
            rstTermine!E_Monat = Month(T_Ende)
            rstTermine!E_Tag = Day(T_Ende)
            rstTermine!E_Stunde = Hour(T_Ende)
            rstTermine!E_Minute = Minute(T_Ende)
            
            rstTermine!lfd_Nr_Kalender = AktKalender
            
            'Termineintrag speichern
            rstTermine.Update
        End If
        
    Else        'kein Termin gefunden
        'erster gefundener Termin:
            
        'Termin "ndern"
        
        Kontakt_verarbeiten
        If FehlerCode <> "" Then Exit Sub
        
        'Test, ob Termin einem anderen Kunden zugeordnet wurde
        If (rstTermine!lfd_Nr_Kunde <> rstKontakte!lfd_Nr) Then
            'Termin wurde einem anderen Kunden zugeordnet
            'aktuellen Termineintrag beim bisherigen Kunden "lschen"...
            rstTermine.Edit
                rstTermine!geloescht = True
                If (rstTermine!berechnet = True) Then
                    'wenn Termin bereits berechnet wurde
                    rstTermine!geaendert_seit_Re = True
                Else
                    If ((rstTermine!Su_Re_Netto = 0) Or (IsNull(rstTermine!Su_Re_Netto))) Then rstTermine!berechnet = True
                End If
                ' Das Update-Datum hier um *eine Sekunde* vermindern, damit der Termin
                ' eventuell noch im selben Updatelauf gelscht werden kann.
                rstTermine!UpdateDatum = (UpdateDatum - 0.000012)
            rstTermine.Update
            
            '...und neuen Eintrag beim anderen Kunden erstellen
'>>>>>>>>
            'Privattermine nur anlegen, wenn die bernahme/Berechnung erwnscht ist
            If (T_Privat = True) And (Privat_verarbeiten = False) Then
                '...nichts tun... (Privattermin, der nicht bernommen werden soll)
            Else
            
                'zuerst Kategorie auflsen und evtl. anlegen,
                'fr Outlook bis 2003 und fr Termin-Kategorien, die nicht in der
                'Kategorie-Liste von Outlook standen (sondern nur im Termin)
                FilterKategorie = "SELECT * FROM Kategorien WHERE [Name1]='" & T_Kategorie & "'"
                Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
                If (rstKategorien.RecordCount = 0) Then
                    'Kategorie nur anlegen, wenn keine Strenge Prfung auf Kategorievorgabeliste
                    'oder sowieso alle Kategorien angelegt werden sollen
                    If (KatStrengePruefung = False) Or (KatUebernahmeArt = 0) Then
                        rstKategorien.AddNew
                        rstKategorien!Kategorie_ID = "X"        'darf nicht leer sein, wegen Abfrage fr Listfeld
                        rstKategorien!Name1 = T_Kategorie
                        rstKategorien!FarbNr = "9999"           ' sh. Update-Routine !!!
                        rstKategorien!Rot = 255                 ' -"- (wei)
                        rstKategorien!Gruen = 255               ' -"-
                        rstKategorien!Blau = 255                ' -"-
                        rstKategorien!Preis_indiv = False
                        rstKategorien!MwSt_indiv = False
                        rstKategorien!MwSteuer = 0
                        rstKategorien.Update
                    Else
                        'bei Strenger Kategorievorgabe die beim Termin gefundene und nicht in der
                        'Vorgabeliste enthaltene Kategorie durch "(ohne Kategorie)" ersetzen!
                        T_Kategorie = "(ohne Kategorie)"
                    End If
                End If
                rstKategorien.Close
            
            
                rstTermine.AddNew
                    rstTermine!lfd_Nr_Kunde = rstKontakte!lfd_Nr
                    'restliche Terminfelder bernehmen
                    rstTermine!Termin_ID = T_ID
                    rstTermine!Start = T_Start
                    rstTermine!Ende = T_Ende
                    rstTermine!Dauer = T_Dauer
                    rstTermine!geloescht = False
                    rstTermine!Betreff = T_Betreff
                    
                    FilterKategorie = "SELECT * FROM Kategorien WHERE [Name1]='" & T_Kategorie & "'"
                    Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
                    rstKategorien.MoveFirst
                        rstTermine!lfd_Nr_Kategorie = rstKategorien!lfd_Nr
                    rstKategorien.Close

                    rstTermine!Privat = T_Privat
                    If km_Erfassung = True Then
                        Kilometer_umwandeln
                        rstTermine!km_Anzahl = km_WertNeu
                    Else
                        rstTermine!km_Anzahl = 0
                    End If
                    rstTermine!berechnet = False
                    rstTermine!geaendert_seit_Re = False
                    rstTermine!Su_Re_Netto = 0
                    rstTermine!Su_Kalkulation = 0
                    'rstTermine!Re_Datum
                    rstTermine!Re_Nr = " "                  'oder anderen Platzhalter?
                    rstTermine!ohne_Adresse = False
                    rstTermine!Update = False
                    rstTermine!UpdateDatum = UpdateDatum
                    'weil Datenbankabfragen mit kombinierten Datum-Zeit-Feldern difiziel sind,
                    'wird der Starttermin zerlegt in der Datenbank gespeichert
                    rstTermine!S_Jahr = Year(T_Start)
                    rstTermine!S_Monat = Month(T_Start)
                    rstTermine!S_Tag = Day(T_Start)
                    rstTermine!S_Stunde = Hour(T_Start)
                    rstTermine!S_Minute = Minute(T_Start)
                    rstTermine!E_Jahr = Year(T_Ende)
                    rstTermine!E_Monat = Month(T_Ende)
                    rstTermine!E_Tag = Day(T_Ende)
                    rstTermine!E_Stunde = Hour(T_Ende)
                    rstTermine!E_Minute = Minute(T_Ende)
                    
                    rstTermine!lfd_Nr_Kalender = AktKalender
                    
                    'Termineintrag speichern
                rstTermine.Update
            End If
        Else
            'keine nderung der Kundenzuordnung
            rstTermine.Edit
            'Terminfelder bernehmen bzw. anpassen
            'rstTermine!lfd_Nr_Kunde                        'keine nderung
            rstTermine!Termin_ID = T_ID
            'rstTermine!Start = meinTermin.Start            'keine Anpassung erforderlich!
            If (rstTermine!Ende <> T_Ende) Then
                'wenn das Terminende gendert wurde
                If (rstTermine!berechnet = True) Then
                    'wenn Termin bereits berechnet wurde
                    rstTermine!geaendert_seit_Re = True
                End If
                rstTermine!Ende = T_Ende
                rstTermine!Dauer = T_Dauer
                'weil Datenbankabfragen mit kombinierten Datum-Zeit-Feldern difiziel sind,
                'wird der Starttermin zerlegt in der Datenbank gespeichert
                rstTermine!E_Jahr = Year(T_Ende)
                rstTermine!E_Monat = Month(T_Ende)
                rstTermine!E_Tag = Day(T_Ende)
                rstTermine!E_Stunde = Hour(T_Ende)
                rstTermine!E_Minute = Minute(T_Ende)
            End If
            rstTermine!geloescht = False
            rstTermine!Betreff = T_Betreff
            
            'zuerst Kategorie auflsen und evtl. anlegen,
            'fr Outlook bis 2003 und fr Termin-Kategorien, die nicht in der
            'Kategorie-Liste von Outlook standen (sondern nur im Termin)
            FilterKategorie = "SELECT * FROM Kategorien WHERE [Name1]='" & T_Kategorie & "'"
            Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
            If (rstKategorien.RecordCount = 0) Then
                'Kategorie nur anlegen, wenn keine Strenge Prfung auf Kategorievorgabeliste
                'oder sowieso alle Kategorien angelegt werden sollen
                If (KatStrengePruefung = False) Or (KatUebernahmeArt = 0) Then
                    rstKategorien.AddNew
                    rstKategorien!Kategorie_ID = "X"        'darf nicht leer sein, wegen Abfrage fr Listfeld
                    rstKategorien!Name1 = T_Kategorie
                    rstKategorien!FarbNr = "9999"           ' sh. Update-Routine !!!
                    rstKategorien!Rot = 255                 ' -"- (wei)
                    rstKategorien!Gruen = 255               ' -"-
                    rstKategorien!Blau = 255                ' -"-
                    rstKategorien!Preis_indiv = False
                    rstKategorien!MwSt_indiv = False
                    rstKategorien!MwSteuer = 0
                    rstKategorien.Update
                Else
                    'bei Strenger Kategorievorgabe die beim Termin gefundene und nicht in der
                    'Vorgabeliste enthaltene Kategorie durch "(ohne Kategorie)" ersetzen!
                    T_Kategorie = "(ohne Kategorie)"
                End If
            End If
            rstKategorien.Close
            
            FilterKategorie = "SELECT * FROM Kategorien WHERE [Name1]='" & T_Kategorie & "'"
            Set rstKategorien = dbs.OpenRecordset(FilterKategorie)
            rstKategorien.MoveFirst
                rstTermine!lfd_Nr_Kategorie = rstKategorien!lfd_Nr
            rstKategorien.Close

            rstTermine!Privat = T_Privat
'>>>>>>>>>>>>
            'Privattermin mit Lschmarkierung versehen, falls Privattermine nicht bernommen werden sollen,
            'aber der Termin von einer frheren bernahme stammt, wo dies erwnscht war
            If (T_Privat = True) And (Privat_verarbeiten = False) Then
                rstTermine!geloescht = True
                If (rstTermine!berechnet = True) Then
                    'wenn Termin bereits berechnet wurde
                    rstTermine!geaendert_seit_Re = True
                Else
                    If ((rstTermine!Su_Re_Netto = 0) Or (IsNull(rstTermine!Su_Re_Netto))) Then rstTermine!berechnet = True
                End If
                ' Das Update-Datum hier um *eine Sekunde* vermindern, damit der Termin
                ' eventuell noch im selben Updatelauf gelscht werden kann.
                rstTermine!UpdateDatum = (UpdateDatum - 0.000012)
            End If
'>>>>>>>>>>>>
            'Lschmarkierung von Privattermin entfernen, falls nach alter Outlookbernahme (noch ohne Neuberechnung)
            'die Privattermine wieder bernommen/berechnet werden sollen
            If (T_Privat = True) And (Privat_verarbeiten = True) And (rstTermine!geloescht = True) Then
                rstTermine!geloescht = False
            End If
            
            If km_Erfassung = True Then
                'wenn die km-Erfassung eingeschaltet ist, dann...
                '...auf Vernderung zu einem evtl. vorhandenen Wert prfen
                Kilometer_umwandeln
                If (rstTermine!km_Anzahl <> km_WertNeu) Then
                    'wenn die Kilometer gendert wurde
                    If (rstTermine!berechnet = True) And (km_Erfassung = True) And (km_Verwendungen = 2) Then
                        'wenn Termin bereits berechnet wurde und die Kilometer auch berechnet
                        'werden sollen, dann nderungskennzeichen setzen
                        rstTermine!geaendert_seit_Re = True
                    End If
                End If
                '...und neuen Wert bernehmen
                rstTermine!km_Anzahl = km_WertNeu
            Else
                '...ansonsten bleibt der alte km-Wert unverndert
            End If
            rstTermine!UpdateDatum = UpdateDatum
            
            rstTermine!lfd_Nr_Kalender = AktKalender
            
            rstTermine.Update
            
        End If

    End If      'vom ersten gefundenen Termin

    '===== Termin verarbeiten Ende =====

    Exit Sub
    

ErrorKontaktNichtGefunden:
    FehlerCode = "ErrorKontaktNichtGefunden"
    FehlerNummer = err.Number
    Exit Sub

ErrorTerminUpdateFehler:
    FehlerCode = "ErrorTerminUpdateFehler"
    FehlerNummer = err.Number
    Exit Sub


End Sub

Public Sub Termine_loeschen()

    '===== Termine loeschen Beginn =====
    FilterTermin = ""
    'alle Termine suchen, die im angegebenen liegen und nicht
    'aktualisiert wurden -> mit Lschmarkierung versehen
    
    FilterTermin = ""
    'nur Termine, deren Beginn oder Ende im angegeben Zeitraum liegen,
    'oder Beginn und Ende vor und nach dem Zeitraum liegen
    ' (
    '   ([Start] < TeKaBe AND [Ende] >= TeKaBe)
    '  OR
    '   ([Start] >= TeKaBe AND [Start] < TeKaEn)
    ' )
    FilterTermin = "SELECT * FROM Termine WHERE (" & _
        "([Start] < #" & Format(TeKaBe, "mm") & "/" & Format(TeKaBe, "Dd") & "/" & Format(TeKaBe, "yyyy") & "# AND [Ende] >= #" & Format(TeKaBe, "mm") & "/" & Format(TeKaBe, "Dd") & "/" & Format(TeKaBe, "yyyy") & "#)" & _
        " OR " & _
        "([Start] >= #" & Format(TeKaBe, "mm") & "/" & Format(TeKaBe, "Dd") & "/" & Format(TeKaBe, "yyyy") & "# AND [Start] < #" & Format(TeKaEn, "mm") & "/" & Format(TeKaEn, "Dd") & "/" & Format(TeKaEn, "yyyy") & "#)"
    'Termine auf KalenderNummer eingrenzen!
    FilterTermin = FilterTermin & " AND ([lfd_Nr_Kalender] = " & AktKalender & ")"
    
    FilterTermin = FilterTermin & ")"
    
'''''    FilterTermin = "SELECT * FROM Termine WHERE ([S_Jahr] <= " & Forms!Outlook_einlesen.Jahresauswahl.Value & ")"
    

    'Termintabelle mit Filter ffnen
    Set rstTermine = dbs.OpenRecordset(FilterTermin)
    If (rstTermine.RecordCount <> 0) Then rstTermine.MoveLast
    Forms!Outlook_einlesen.PruefenNummerGesamt.Caption = rstTermine.RecordCount
    Forms!Outlook_einlesen.PruefenNummerAktuell.Caption = "0"
    Forms!Outlook_einlesen.Repaint
    ' 1 Sekunde abziehen, damit die Anzeige zu Beginn garantiert akt. wird
    AktuelleZeit = Fix(Timer) - 1
    NummeroTermin = 0
    'wenn mindestens ein Termin gefunden...
    If (rstTermine.RecordCount > 0) Then
        'alle gefundenen Datenstze durchgehen
        rstTermine.MoveLast         'auffllen
        rstTermine.MoveFirst
        Do While Not rstTermine.EOF
            'Anzeige aktualisieren
            NummeroTermin = NummeroTermin + 1
            If Fix(Timer) > AktuelleZeit Then
                'den 1. Termin und dann jede Sekunde anzeigen
                Forms!Outlook_einlesen.PruefenNummerAktuell.Caption = NummeroTermin
                Forms!Outlook_einlesen.Repaint
                AktuelleZeit = Fix(Timer)
            End If
'''''            If (Year(rstTermine!Start) < Forms!Outlook_einlesen.Jahresauswahl.Value) Then
'''''                'wenn ein frherer Termin in das ausgew. Jahr rein- oder noch weiter reicht
'''''                If (Year(rstTermine!Ende) >= Forms!Outlook_einlesen.Jahresauswahl.Value) Then
                
                    'mit Lschmarkierung versehen, falls Termin nicht im selben Lauf aktualisiert wurde
                    If (rstTermine!UpdateDatum <> UpdateDatum) Then
                        rstTermine.Edit
                        rstTermine!geloescht = True
                        'Wenn Termin noch nicht berechnet worden ist, Abrechnungskennzeichen setzen,
                        'damit nicht ein gelschter Termin berechnet wird.
                        If (rstTermine!berechnet = True) Then
                            'wenn Termin bereits berechnet wurde
                            rstTermine!geaendert_seit_Re = True
                        End If
                        If ((rstTermine!Su_Re_Netto = 0) Or (IsNull(rstTermine!Su_Re_Netto))) Then
                            rstTermine!berechnet = True
                            rstTermine!geaendert_seit_Re = False
                        End If
                        rstTermine.Update
                    End If
 '>>>>>>>>>>>>>
                    'mit Lschmarkierung versehen, falls Privattermine nicht berechnet werden sollen
                    If (rstTermine!Privat = True) And (Privat_verarbeiten = False) Then
                        rstTermine.Edit
                        rstTermine!geloescht = True
                        'Wenn Termin noch nicht berechnet worden ist, Abrechnungskennzeichen setzen,
                        'damit nicht ein gelschter Termin berechnet wird.
                        If (rstTermine!berechnet = True) Then
                            'wenn Termin bereits berechnet wurde
                            rstTermine!geaendert_seit_Re = True
                        End If
                        If ((rstTermine!Su_Re_Netto = 0) Or (IsNull(rstTermine!Su_Re_Netto))) Then
                            rstTermine!berechnet = True
                            rstTermine!geaendert_seit_Re = False
                        End If
                        rstTermine.Update
                    End If
                    
                    
                    

            rstTermine.MoveNext
        Loop
        'Anzeige aktualisieren
        Forms!Outlook_einlesen.PruefenNummerAktuell.Caption = NummeroTermin
        Forms!Outlook_einlesen.Repaint
    End If
    'Termintabelle wieder schlieen
    rstTermine.Close
    
End Sub
    
Public Sub Termine_entfernen()

    
    'Und jetzt noch alle Termine, die eine Lschmarkierung haben und nicht mehr
    'fr Rechnungen bentigt werden: -> endgltig entfernen!
    '===========================================================================
    Set rstTermine_geloescht = dbs.OpenRecordset("Termine_geloescht")
    FilterTermin = ""
    'alle Termine suchen, die folgende Markierungen haben:
    'gelscht=JA, berechnet=JA, gendert_seit_Rechnung=NEIN
    FilterTermin = "SELECT * FROM Termine WHERE (([geloescht] = True) AND ([berechnet] = True) AND ([geaendert_seit_Re] = False))"
    'Termintabelle mit Filter ffnen
    Set rstTermine = dbs.OpenRecordset(FilterTermin)
    If (rstTermine.RecordCount <> 0) Then rstTermine.MoveLast
    Forms!Outlook_einlesen.TerminLoeschenGesamt.Caption = rstTermine.RecordCount
    Forms!Outlook_einlesen.TerminLoeschenAktuell.Caption = "0"
    Forms!Outlook_einlesen.Repaint
    NummeroTermin = 0
    'wenn mindestens ein Termin gefunden...
    If (rstTermine.RecordCount > 0) Then
        'alle gefundenen Datenstze durchgehen
        rstTermine.MoveLast             'auffllen!
        rstTermine.MoveFirst
        Do While Not rstTermine.EOF
            'Anzeige aktualisieren
            NummeroTermin = NummeroTermin + 1
            Forms!Outlook_einlesen.TerminLoeschenAktuell.Caption = NummeroTermin
            Forms!Outlook_einlesen.Repaint
            'Eintrge des Kalender-Rasters lschen
            Set rst = dbs.OpenRecordset("SELECT * FROM Termine_Kalender WHERE [lfd_Nr_Termin]=" & rstTermine!lfd_Nr)
            If rst.RecordCount > 0 Then
                rst.MoveLast        'auffllen
                rst.MoveFirst
                Do While Not rst.EOF
                    rst.Delete
                    rst.MoveNext
                Loop
            End If
            rst.Close
            'Eintrag in Liste gelschter Termine kopieren...
            rstTermine_geloescht.AddNew
                rstTermine_geloescht!lfd_Nr_Kunde = rstTermine!lfd_Nr_Kunde
                rstTermine_geloescht!lfd_Nr_Kategorie = rstTermine!lfd_Nr_Kategorie
                rstTermine_geloescht!lfd_Nr_Termin = rstTermine!lfd_Nr
                rstTermine_geloescht!Termin_ID = rstTermine!Termin_ID
                rstTermine_geloescht!Start = rstTermine!Start
                rstTermine_geloescht!Ende = rstTermine!Ende
                rstTermine_geloescht!Dauer = rstTermine!Dauer
                'Hkchen bei "gelscht" explizit setzen
                rstTermine_geloescht!geloescht = True
                rstTermine_geloescht!Betreff = rstTermine!Betreff
                rstTermine_geloescht!Privat = rstTermine!Privat
                rstTermine_geloescht!km_Anzahl = rstTermine!km_Anzahl
                rstTermine_geloescht!berechnet = rstTermine!berechnet
                'Hkchen bei "berechnet" ggf. korrigieren
                If (IsNull(rstTermine!Re_Datum)) Then rstTermine_geloescht!berechnet = False
                rstTermine_geloescht!geaendert_seit_Re = rstTermine!geaendert_seit_Re
                rstTermine_geloescht!Su_Re_Netto = rstTermine!Su_Re_Netto
                'Kalkulation bei gelschtem Termin unwichtig (auf 0 setzen)
                rstTermine_geloescht!Su_Kalkulation = 0
                rstTermine_geloescht!Re_Datum = rstTermine!Re_Datum
                rstTermine_geloescht!Re_Nr = rstTermine!Re_Nr
                rstTermine_geloescht!ohne_Adresse = rstTermine!ohne_Adresse
                rstTermine_geloescht!Update = rstTermine!Update
                'aktuelles Update-Datum eintragen
                rstTermine_geloescht!UpdateDatum = UpdateDatum
                rstTermine_geloescht!S_Jahr = rstTermine!S_Jahr
                rstTermine_geloescht!S_Monat = rstTermine!S_Monat
                rstTermine_geloescht!S_Tag = rstTermine!S_Tag
                rstTermine_geloescht!S_Stunde = rstTermine!S_Stunde
                rstTermine_geloescht!S_Minute = rstTermine!S_Minute
                rstTermine_geloescht!E_Jahr = rstTermine!E_Jahr
                rstTermine_geloescht!E_Monat = rstTermine!E_Monat
                rstTermine_geloescht!E_Tag = rstTermine!E_Tag
                rstTermine_geloescht!E_Stunde = rstTermine!E_Stunde
                rstTermine_geloescht!E_Minute = rstTermine!E_Minute
            rstTermine_geloescht.Update
            '...und Eintrag aus Liste aktueller Termine entfernen
            rstTermine.Delete
            rstTermine.MoveNext
        Loop
    End If
    'Termintabelle wieder schlieen
    rstTermine.Close
    rstTermine_geloescht.Close
    '===== Termine loeschen Ende =====


End Sub

Public Sub KalenderGenerieren()

    '=======================================================================
    ' Diese SUB ist nach Umprogrammierung komplett berflssig geworden!!!!
    '=======================================================================



    '===== LEEREN Kalender generieren - Beginn =====
    FilterKalender = ""
    'Kalender auf aktuellen Kunden, und Jahr filtern...
    'Alle Monate eines Jahres prfen, da auch bei kurzem bernahmezeitraum der Termin
    'ber mehrere Monate gehen kann.
    
    FilterKalender = "SELECT * FROM Termine_Kalender WHERE " & _
        "(" & _
            "([lfd_Nr_Kunde] = " & KalenderKunde & ")" & _
            " AND " & _
            "([Jahr] = " & KalenderJahr & ")" & _
        ")"
    
    Set rstKalender = dbs.OpenRecordset(FilterKalender)
    If (rstKalender.RecordCount <> 0) Then rstKalender.MoveLast
    If (rstKalender.RecordCount = 0) Then
        'keine Kalendereintrge zu lschen, ergo neuen leeren Kalender anlegen:
        
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 1
            rstKalender!Monat = "Jan"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 2
            rstKalender!Monat = "Feb"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 3
            rstKalender!Monat = "Mrz"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 4
            rstKalender!Monat = "Apr"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 5
            rstKalender!Monat = "Mai"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 6
            rstKalender!Monat = "Jun"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 7
            rstKalender!Monat = "Jul"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 8
            rstKalender!Monat = "Aug"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 9
            rstKalender!Monat = "Sep"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 10
            rstKalender!Monat = "Okt"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 11
            rstKalender!Monat = "Nov"
        rstKalender.Update
        rstKalender.AddNew
            rstKalender!lfd_Nr_Kunde = KalenderKunde
            rstKalender!Jahr = KalenderJahr
            rstKalender!Monat_Nr = 12
            rstKalender!Monat = "Dez"
        rstKalender.Update
        
        rstKalender.Close
    Else
        'alle gefundenen Kalendertage lschen...
        
        'dazu wird die Routine "TerminInDenKalender" benutzt,
        'nur dass hier der Termin AUSgetragen wird (TerminEinAusTragen = False)
        
        
        TerminEinAusTragen = False
        TerminInDenKalender
        
            
            
            
            
            
            
'''''        rstKalender.MoveFirst
'''''        Do While Not rstKalender.EOF
'''''            rstKalender.Delete
'''''            rstKalender.MoveNext
'''''        Loop
'''''        rstKalender.Close
    End If
    
    
'''''    'neues, leeres Monatsraster in den Kalender eintragen
'''''    Set rstKalender = dbs.OpenRecordset("Termine_Kalender")
'''''    rstKalender.Requery
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 1
'''''        rstKalender!Monat = "Jan"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 2
'''''        rstKalender!Monat = "Feb"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 3
'''''        rstKalender!Monat = "Mrz"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 4
'''''        rstKalender!Monat = "Apr"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 5
'''''        rstKalender!Monat = "Mai"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 6
'''''        rstKalender!Monat = "Jun"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 7
'''''        rstKalender!Monat = "Jul"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 8
'''''        rstKalender!Monat = "Aug"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 9
'''''        rstKalender!Monat = "Sep"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 10
'''''        rstKalender!Monat = "Okt"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 11
'''''        rstKalender!Monat = "Nov"
'''''    rstKalender.Update
'''''    rstKalender.AddNew
'''''        rstKalender!lfd_Nr_Kunde = KalenderKunde
'''''        rstKalender!Jahr = KalenderJahr
'''''        rstKalender!Monat_Nr = 12
'''''        rstKalender!Monat = "Dez"
'''''    rstKalender.Update
'''''    'Kalenderdatei schlieen
'''''    rstKalender.Close
    '===== Kalender generieren Ende =====

End Sub

Public Sub TerminInDenKalender()
    
    ' Es wird immer fr den GESAMTEN Terminzeitraum das Kalenderraster erstellt !
    '============================================================================
    ' hnliche Routine auch in der Datenbank-Update-Routine!
    '-------------------------------------------------------
    
    'erst alte Kalender-Raster mit "Lschmarkierung" versehen
    Set rstKalender = dbs.OpenRecordset("SELECT * FROM Termine_Kalender WHERE [lfd_Nr_Termin]=" & rstTermine!lfd_Nr)
    If rstKalender.RecordCount > 0 Then
        rstKalender.MoveLast        'auffllen
        rstKalender.MoveFirst
        Do While Not rstKalender.EOF
            rstKalender.Edit
            rstKalender!Monat = "XXX"   'Lschmarkierung
            rstKalender.Update
            rstKalender.MoveNext
        Loop
    End If
    rstKalender.Close
    
    'Startdatum kopieren, da dies bis zum Endedatum hochgezhlt wird
    KalenderDatum = Format(rstTermine!S_Tag, "00") & "." & Format(rstTermine!S_Monat, "00") & "." & Format(rstTermine!S_Jahr, "0000")
    'Datei fr Kalender-Raster ffnen
    Set rstKalender = dbs.OpenRecordset("SELECT * FROM Termine_Kalender")
    If (rstKalender.RecordCount <> 0) Then rstKalender.MoveLast     'auffllen!
    Do While KalenderDatum <= rstTermine!Ende
        'Jahr/Monats-Eintrag suchen
        rstKalender.FindFirst "[lfd_Nr_Termin]=" & rstTermine!lfd_Nr & " AND [Jahr]=" & Year(KalenderDatum) & " AND [Monat_Nr]=" & Month(KalenderDatum)
        If rstKalender.NoMatch Then
            'neuen Eintrag fr Jahr/Monat anlegen
            rstKalender.AddNew
            rstKalender!lfd_Nr_Termin = rstTermine!lfd_Nr
            rstKalender!lfd_Nr_Kunde = rstTermine!lfd_Nr_Kunde
            rstKalender!lfd_Nr_Kalender = rstTermine!lfd_Nr_Kalender
            rstKalender!lfd_Nr_Kategorie = rstTermine!lfd_Nr_Kategorie
            rstKalender!Jahr = Year(KalenderDatum)
            rstKalender!Monat_Nr = Month(KalenderDatum)
            Select Case Month(KalenderDatum)
                Case 1
                    rstKalender!Monat = "Jan"
                Case 2
                    rstKalender!Monat = "Feb"
                Case 3
                    rstKalender!Monat = "Mrz"
                Case 4
                    rstKalender!Monat = "Apr"
                Case 5
                    rstKalender!Monat = "Mai"
                Case 6
                    rstKalender!Monat = "Jun"
                Case 7
                    rstKalender!Monat = "Jul"
                Case 8
                    rstKalender!Monat = "Aug"
                Case 9
                    rstKalender!Monat = "Sep"
                Case 10
                    rstKalender!Monat = "Okt"
                Case 11
                    rstKalender!Monat = "Nov"
                Case 12
                    rstKalender!Monat = "Dez"
            End Select
            rstKalender.Update
            rstKalender.Bookmark = rstKalender.LastModified
        End If
        'Eintrag vorbereiten
        rstKalender.Edit
        'rstKalender!lfd_Nr_Termin = rstTermine!lfd_Nr
        rstKalender!lfd_Nr_Kunde = rstTermine!lfd_Nr_Kunde
        rstKalender!lfd_Nr_Kalender = rstTermine!lfd_Nr_Kalender
        rstKalender!lfd_Nr_Kategorie = rstTermine!lfd_Nr_Kategorie
        'rstKalender!Jahr = Year(KalenderDatum)
        'rstKalender!Monat_Nr = Month(KalenderDatum)
        rstKalender!T01 = False
        rstKalender!T02 = False
        rstKalender!T03 = False
        rstKalender!T04 = False
        rstKalender!T05 = False
        rstKalender!T06 = False
        rstKalender!T07 = False
        rstKalender!T08 = False
        rstKalender!T09 = False
        rstKalender!T10 = False
        rstKalender!T11 = False
        rstKalender!T12 = False
        rstKalender!T13 = False
        rstKalender!T14 = False
        rstKalender!T15 = False
        rstKalender!T16 = False
        rstKalender!T17 = False
        rstKalender!T18 = False
        rstKalender!T19 = False
        rstKalender!T20 = False
        rstKalender!T21 = False
        rstKalender!T22 = False
        rstKalender!T23 = False
        rstKalender!T24 = False
        rstKalender!T25 = False
        rstKalender!T26 = False
        rstKalender!T27 = False
        rstKalender!T28 = False
        rstKalender!T29 = False
        rstKalender!T30 = False
        rstKalender!T31 = False
        rstKalender.Update
        rstKalender.Bookmark = rstKalender.LastModified
        KalenderMonat = Month(KalenderDatum)
        Do While ((Month(KalenderDatum) = KalenderMonat) And (KalenderDatum <= rstTermine!Ende))
            'aktuellen Monat evt. durchgehen, falls Termin ber mehrere Tage (maximal bis Monatsende oder Terminende)
            If (KalenderDatum = rstTermine!Ende) And (rstTermine!E_Stunde = 0) And (rstTermine!E_Minute = 0) Then
                'bei Ganztags-Terminen: 00:00 Uhr des letzten Tages abfangen!
                '(kein Hkchen setzen)
            Else
                rstKalender.Edit
                Select Case Day(KalenderDatum)
                    Case 1
                        rstKalender!T01 = True
                    Case 2
                        rstKalender!T02 = True
                    Case 3
                        rstKalender!T03 = True
                    Case 4
                        rstKalender!T04 = True
                    Case 5
                        rstKalender!T05 = True
                    Case 6
                        rstKalender!T06 = True
                    Case 7
                        rstKalender!T07 = True
                    Case 8
                        rstKalender!T08 = True
                    Case 9
                        rstKalender!T09 = True
                    Case 10
                        rstKalender!T10 = True
                    Case 11
                        rstKalender!T11 = True
                    Case 12
                        rstKalender!T12 = True
                    Case 13
                        rstKalender!T13 = True
                    Case 14
                        rstKalender!T14 = True
                    Case 15
                        rstKalender!T15 = True
                    Case 16
                        rstKalender!T16 = True
                    Case 17
                        rstKalender!T17 = True
                    Case 18
                        rstKalender!T18 = True
                    Case 19
                        rstKalender!T19 = True
                    Case 20
                        rstKalender!T20 = True
                    Case 21
                        rstKalender!T21 = True
                    Case 22
                        rstKalender!T22 = True
                    Case 23
                        rstKalender!T23 = True
                    Case 24
                        rstKalender!T24 = True
                    Case 25
                        rstKalender!T25 = True
                    Case 26
                        rstKalender!T26 = True
                    Case 27
                        rstKalender!T27 = True
                    Case 28
                        rstKalender!T28 = True
                    Case 29
                        rstKalender!T29 = True
                    Case 30
                        rstKalender!T30 = True
                    Case 31
                        rstKalender!T31 = True
                End Select
                ' "Lschmarkierung" wieder entfernen und missbrauchtes Feld inhaltlich wieder herstellen
                Select Case rstKalender!Monat_Nr
                    Case 1
                        rstKalender!Monat = "Jan"
                    Case 2
                        rstKalender!Monat = "Feb"
                    Case 3
                        rstKalender!Monat = "Mrz"
                    Case 4
                        rstKalender!Monat = "Apr"
                    Case 5
                        rstKalender!Monat = "Mai"
                    Case 6
                        rstKalender!Monat = "Jun"
                    Case 7
                        rstKalender!Monat = "Jul"
                    Case 8
                        rstKalender!Monat = "Aug"
                    Case 9
                        rstKalender!Monat = "Sep"
                    Case 10
                        rstKalender!Monat = "Okt"
                    Case 11
                        rstKalender!Monat = "Nov"
                    Case 12
                        rstKalender!Monat = "Dez"
                End Select
                rstKalender.Update
                rstKalender.Bookmark = rstKalender.LastModified
            End If
            KalenderDatum = KalenderDatum + 1
        Loop
    Loop
    rstKalender.Close
    
    'brige Kalenderraster mit "Lschmarkierung" nun entfernen
    Set rstKalender = dbs.OpenRecordset("SELECT * FROM Termine_Kalender WHERE [lfd_Nr_Termin]=" & rstTermine!lfd_Nr & " AND [Monat]='XXX'")
    If rstKalender.RecordCount > 0 Then
        rstKalender.MoveLast        'auffllen
        rstKalender.MoveFirst
        Do While Not rstKalender.EOF
            rstKalender.Delete
            rstKalender.MoveNext
        Loop
    End If
    rstKalender.Close
    
    
End Sub
